import sys
from collections import defaultdict

data = sys.stdin.read().split()
n = int(data[0])

by_y = defaultdict(lambda: [0, 0])  # y -> [even x, odd x]
by_x = defaultdict(lambda: [0, 0])  # x -> [even y, odd y]
diag_s = defaultdict(int)           # x + y
diag_d = defaultdict(int)           # x - y

idx = 1
for _ in range(n):
    x = int(data[idx])
    y = int(data[idx + 1])
    idx += 2

    by_y[y][x & 1] += 1
    by_x[x][y & 1] += 1
    diag_s[x + y] += 1
    diag_d[x - y] += 1

ans = 0

# horizontalni (E-W)
for even_cnt, odd_cnt in by_y.values():
    ans += even_cnt * (even_cnt - 1) // 2
    ans += odd_cnt * (odd_cnt - 1) // 2

# vertikalni (N-S)
for even_cnt, odd_cnt in by_x.values():
    ans += even_cnt * (even_cnt - 1) // 2
    ans += odd_cnt * (odd_cnt - 1) // 2

# ukršteni (dijagonale)
for k in diag_s.values():
    ans += k * (k - 1) // 2
for k in diag_d.values():
    ans += k * (k - 1) // 2

print(ans)